
;DEFINE VARIABLES BEGIN


breed [cxcr4-cells cxcr4-cell]
breed [cxcr7-cells cxcr7-cell]

globals 
[   
  leading-turtle  ;used in determining fraction of PLLp occupied by CXCR4-cells and CXCR7-cells
  trailing-turtle  ;used in determining fraction of PLLp occupied by CXCR4-cells and CXCR7-cells                  
  moving-turtles       ; define set of turtles to separate them from not-moving-turtles after cut 
  not-moving-turtles   ; define set of turtles to separate them from moving-turtles after cut 
  links-to-break ; keeps track of list of links broken to reconnect later
  links-before-broken ; keeps track of list of links before broken
  turtles-to-join-first ;used to keep track of turtles at either ends of the broken links: to be used when joining after cut
  turtles-to-join-second ;used to keep track of turtles at either ends of the broken links: to be used when joining after cut
  cxcr7_max_xcor  ;used in determining fraction of PLLp occupied by CXCR4-cells and CXCR7-cells
  need-to-join ; set to 1 when cut is made and incremented till 20 before being reset to 0, so that the moving turtles are not joined in the very next tick after cut
  time-count ; keeps track of the number of ticks
]

patches-own
[
  Cxcl12a
]

turtles-own
[
  leading_turtle_agent
  trailing_turtle_agent
  group
  Cxcl12a_gradient
]

links-own
[link_group]  ;separates links depending on which fragment links are in after a cut


;DEFINE VARIABLES END



;SETUP BEGIN

to Setup-pllp-Migration

clear-all

initialize-cells
initialize-Cxcl12a 
  

reset-ticks

end


;SETUP END



;MAIN PROGRAM BLOCK BEGIN
 
to go
 
;these lines reset the turtles to their original color after flashing yellow to show movement
ask cxcr4-cells
[set color 64.5 set shape "circle 2"]
ask cxcr7-cells
[set color 14.5 set shape "circle 2"]
 


;subroutines
rejoin-if-cut
produce-and-degrade-Cxcl12a
agent-movement
visco-elasticity
  
set time-count time-count + 1 
tick
  
end


;MAIN PROGRAN BLOCK END




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SUBROUTINES BEGIN;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;






;;;;;;;;;;;;;;;;;;;; INITIALIZATION OF CXCL12A PATTERN ;;;;;;;;;;;;;;;;;;;;  

to initialize-Cxcl12a

repeat 30  ;Initialize Cxcl12a pattern
  [
    repeat 5
    [
      diffuse Cxcl12a Cxcl12a-diffusion-rate
    ]
    ask patches
    [
      if pxcor >= 0
      [
      if abs pycor < stripe-width
      [
        set Cxcl12a (Cxcl12a + Cxcl12a-production-rate)
      ] 
      set Cxcl12a ( Cxcl12a * Cxcl12a-degradation-rate) 
      set pcolor scale-color blue     Cxcl12a   0 100 
    ]]
  ]
end


;;;;;;;;;;;;;;;;;;;; INITIALIZING CELLS ;;;;;;;;;;;;;;;;;;;;

to initialize-cells

 ask patches
[
   if ((pxcor - 20) ^ 2) + (5 * pycor ^ 2 ) < cluster-size
    [sprout-cxcr4-cells 1] 
]


set leading-turtle [xcor] of max-one-of turtles [xcor]
set trailing-turtle [xcor] of min-one-of turtles [xcor]  

set cxcr7_max_xcor  trailing-turtle + ((leading-turtle - trailing-turtle) / 100) * cxcr7-fraction

ask turtles 
[
ifelse cxcr7-fraction = 100
[set breed cxcr7-cells]
[if xcor <  cxcr7_max_xcor [set breed cxcr7-cells]] 
]
 
 
 
;set up shape and color of turtles
 
ask cxcr4-cells
[set color 64.5
  set size 1
 set shape "circle 2"
 ]
ask cxcr7-cells
[set color 14.5
  set size 1
 set shape "circle 2"
]




 
   ask turtles
  [
    create-links-with turtles-on neighbors4
  ]  



;these agents are used for making a plot of migration

ask patch 27 0
[ask turtles-here 
  [set leading_turtle_agent 1
    ]
]

ask patch 13 0
[ask turtles-here 
  [set trailing_turtle_agent 1
   ]
]

; initialize moving turtles to set of all turtles and need-to-join to 0 since we have not cut yet
set moving-turtles (turtle-set cxcr4-cells cxcr7-cells) 
set need-to-join 0
 
 
  
end



;;;;;;;;;;;;;;;;;;;; CXCL12A DEGREDATION AND PRODUCTION ;;;;;;;;;;;;;;;;;;;;  


to produce-and-degrade-Cxcl12a
  
  ask cxcr7-cells
  [
    ask patch-at 0 0 [set Cxcl12a (Cxcl12a * (1 - cxcr7-degradation))]
    ask patch-at 0 0 [ask neighbors [set Cxcl12a (Cxcl12a * (1 - cxcr7-degradation))]]
    ask patch-at 0 0 [set Cxcl12a (Cxcl12a * (1 - cxcr4-degradation))]
      ]
  ask cxcr4-cells
  [
   ask patch-at 0 0 [set Cxcl12a (Cxcl12a  * (1 - cxcr4-degradation))]
  ] 
    
  ask patches
  [
    
    if abs pycor < stripe-width
    [if pxcor >= 0 
    [if pxcor <= max [pxcor] of patches
    
    [
      set Cxcl12a (Cxcl12a + Cxcl12a-production-rate)
    ] ] ]
    
    set Cxcl12a ( Cxcl12a * (1 - Cxcl12a-degradation-rate)) 
    set pcolor scale-color blue Cxcl12a   0 scale ]
  
    repeat Cxcl12a-diffusion-distance
    [
      diffuse Cxcl12a Cxcl12a-diffusion-rate
    ]

   
 end
 
 
 
to agent-movement

;;;;;;;;;;;;;;;;;;;; AGENT MOVEMENT ;;;;;;;;;;;;;;;;;;;;



ask turtles
[
   right random 60 left random 60
    ifelse [Cxcl12a] of patch-ahead 1 > [Cxcl12a] of patch-here
    [set Cxcl12a_gradient [Cxcl12a] of patch-ahead 1 - [Cxcl12a] of patch-here]
    [set Cxcl12a_gradient 0]
   ;if ([sdf] of patch-ahead 1 / (1 + [sdf] of patch-ahead 1)) > movement-threshold [fd speed]


  
  
  ifelse edge-cell-active = false

[
  ifelse gradient-sensing = true
  [  if (Cxcl12a_gradient / (1 + Cxcl12a_gradient)) > movement-threshold 
        [fd speed set color yellow set shape "clock2"]]
  [  
   if ([Cxcl12a] of patch-ahead 1 / (1 + [Cxcl12a] of patch-ahead 1)) > movement-threshold
   
    [fd speed set color yellow set shape "clock2"]
    
    ]
]
  
[ 
   ifelse any? link-neighbors in-cone 5 120
         [right random 60 left random 60]
  [
     ifelse gradient-sensing = true
  [  if (Cxcl12a_gradient / (1 + Cxcl12a_gradient)) > movement-threshold 
 
    [fd speed set color yellow set shape "clock2"]]
  [  
     
      if ([Cxcl12a] of patch-ahead 1 / (1 + [Cxcl12a] of patch-ahead 1)) > movement-threshold
    
    [fd speed set color yellow set shape "clock2"]
    ]
  ]
  
]

]

end


to visco-elasticity

;link code rearrange turtles based on spring parameters
   
 if any? turtles with [group = 1]
 [  
  ask turtles with [group = 1]
  [
    repeat 1
    [ 
     layout-spring turtles with [group = 1] links spring-constant spring-length spring-repulsion
   ]
  ]   
 ] 
 
  ask turtles with [group = 0]
  [
    repeat 1
    [ 
     layout-spring turtles with [group = 0] links with [link_group = 0]  spring-constant spring-length spring-repulsion
   ]
  ]   

 
end


;;;;;;;;;;;;;;;;;;;; CUT AND REJOIN BEHAVIOR ;;;;;;;;;;;;;;;;;;;;

to rejoin-if-cut     
    
  if(need-to-join > 0)
  [
    set need-to-join (need-to-join + 1) ; count ticks after cut was made
  ] 
 
  if (need-to-join > 70) ; check for rejoin only after 20 ticks so that the two cut parts get far enough apart
  [   
    let close-enough 0 ; rejoin only if the two parts are close enough again
    
    ; find the smallest distance between the xcor of any two turtles in the two parts, enough to compare min and max xcor
    let min-moving-xcor (min [xcor] of moving-turtles)
    let max-moving-xcor (max [xcor] of moving-turtles)
    let min-not-moving-xcor (min [xcor] of not-moving-turtles)
    let max-not-moving-xcor (max [xcor] of not-moving-turtles)
  
    ; diff1 > 0 if the moving part is to the right  of not-moving part
    let diff1 (min-moving-xcor - max-not-moving-xcor)
    if (diff1 < 0) [ set diff1 (- diff1) ]
    
    ; diff2 > 0 if the moving part is to the left  of not-moving part
    let diff2 (max-moving-xcor - min-not-moving-xcor)
    if (diff2 < 0) [ set diff2 (- diff2) ]
    
    ; if either of these is < 3 means the two parts are within 3 pixel close
    if (diff1 < 1) or (diff2 < 1)
    [ 
      set close-enough 1
    ]

    ; rejoin the cut parts if found to be close 
    if (close-enough = 1)
    [
      let second-index 0
      
      join-broken-links ; rejoins exactly the broken links as they were using the turtle lists on either ends of the broken links
      set moving-turtles turtles ; let all turtles move again
      set need-to-join 0 ; reset need-to-join
    ]
  ]
  

  
end


; to find links to cut: based on a cutoff x-coordinate (this cutoff-xcor is calculated from either mouse-click or a cut-fraction slider when cut button is pressed)
to find-links-at-xcor [cutoff-xcor]
  
  set links-to-break []
  set turtles-to-join-first []
  set turtles-to-join-second []
  
  ; check each link if its ends fall on either side of the cutoff-xcor
  ask links
  [
    let temp-end2 end2
    let temp-end1 end1
    let temp-link self
    ask end1 
    [
      ifelse (xcor <= cutoff-xcor) 
      [ 
        ; end1 has xcor <= cutoff-xcor, so if end2 has xcor > cutoff-xcor then add this link to the set of links to be cut
        ask temp-end2 
        [
          if(xcor > cutoff-xcor)
          [
            ; keep track of link to break and either end turtles
            set links-to-break (fput temp-link links-to-break)
            set turtles-to-join-first (fput temp-end1 turtles-to-join-first)
            set turtles-to-join-second (fput temp-end2 turtles-to-join-second)
          ]
        ]
      ]
      [
        ; end1 has xcor > cutoff-xcor, so if end2 has xcor <= cutoff-xcor then add this link to the set of links to be cut
        ask temp-end2 
        [
          if (xcor <= cutoff-xcor) 
          [
            ; keep track of link to break and either end turtles
            set links-to-break (fput temp-link links-to-break)
            set turtles-to-join-first (fput temp-end1 turtles-to-join-first)
            set turtles-to-join-second (fput temp-end2 turtles-to-join-second)
          ]
        ]
      ]
    ]
  ]
  print "breaking links: "
  show links-to-break
  
end

; to cut using cut-fraction slider
to cut-by-fraction
  
  if (need-to-join = 0) ; this check is needed because if need-to-join is 1, it means a cut was already done, so no need to react to mouse click
  [
    set moving-turtles no-turtles
    ask turtles [set group 0]
    let min-xcor (min [xcor] of turtles)
    let max-xcor (max [xcor] of turtles)
    let cxcr4-max-xcor (max [xcor] of cxcr4-cells)
    ifelse (cxcr4-max-xcor = max-xcor)
    [
      ; calculate cutoff-xcor from cut-fraction slider as the % from min-xcor
      let cutoff-xcor (min-xcor + (cut-fraction * (max-xcor - min-xcor) ) / 100 )
      find-links-at-xcor (cutoff-xcor)
      set moving-turtles (turtles with [xcor > cutoff-xcor] )
            ask turtles with [xcor >= cutoff-xcor] [set group 1]
            
    ]
    [
      ; calculate cutoff-xcor from 100-cut-fraction slider as the % from min-xcor
      let cutoff-xcor (min-xcor + ( (100 - cut-fraction) * (max-xcor - min-xcor) ) / 100 )
      find-links-at-xcor (cutoff-xcor)
      set moving-turtles (turtles with [xcor >= cutoff-xcor] )
      ask turtles with [xcor >= cutoff-xcor] [set group 1]
      
      
    ]
    ; cut links to be broken 
    cut-links
  ]
  
end

; to cut the links to be broken which were determined before in find-links-at-xcor
to cut-links
  ; save links before broken for debugging only
  set links-before-broken links
  ask links
  [
    if (member? self links-to-break)
    [ 
      ; remove link from the list and ask it to die
      set links-to-break (remove self links-to-break)
      die 
    ]
  ]
  
  ; set not-moving turtles as complement of moving-turtles
  set not-moving-turtles no-turtles
  ask turtles 
  [ 
    ifelse (member? self moving-turtles) 
    [ ]
    [
      set not-moving-turtles (turtle-set self not-moving-turtles)
    ]
  ]
 
  ; now that we cut set the flag to rejoin
  set need-to-join 1

end

; to join broken links
to join-broken-links
  
  let list-index 0
  repeat (length turtles-to-join-first)
  [
    ; go over the list of turtles which were saved from link ends that were broken and establish links between them once again
    ask (item list-index turtles-to-join-first)
    [
      create-link-with (item list-index turtles-to-join-second)
      print (list"link created between " self (item list-index turtles-to-join-second) )
    ]
    set list-index (list-index + 1)
  ]
  
  ask turtles [set group 0]
  
end
 
 




 
@#$#@#$#@
GRAPHICS-WINDOW
265
15
1093
183
-1
8
8.1
1
30
1
1
1
0
1
1
1
0
100
-8
8
1
1
1
ticks
30.0

BUTTON
15
30
115
65
Setup
Setup-pllp-Migration
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
120
30
220
65
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
765
410
925
443
spring-constant
spring-constant
0
1
0.15
0.01
1
NIL
HORIZONTAL

SLIDER
765
330
925
363
spring-length
spring-length
0
1
0.3
0.05
1
NIL
HORIZONTAL

SLIDER
765
370
925
403
spring-repulsion
spring-repulsion
0
.1
0.01
0.001
1
NIL
HORIZONTAL

SLIDER
1720
655
1861
688
sdf-threshold-value
sdf-threshold-value
0
20
1
1
1
NIL
HORIZONTAL

SLIDER
235
410
395
443
Cxcl12a-diffusion-rate
Cxcl12a-diffusion-rate
0
1
0.1
0.05
1
NIL
HORIZONTAL

SLIDER
235
370
395
403
Cxcl12a-production-rate
Cxcl12a-production-rate
0
20
3
.1
1
NIL
HORIZONTAL

SLIDER
585
410
745
443
Cxcl12a-degradation-rate
Cxcl12a-degradation-rate
0
1
0.05
0.05
1
NIL
HORIZONTAL

SLIDER
585
370
745
403
cxcr7-degradation
cxcr7-degradation
0
1
0.8
.1
1
NIL
HORIZONTAL

SLIDER
235
330
395
363
stripe-width
stripe-width
0
5
1
1
1
NIL
HORIZONTAL

SLIDER
55
330
215
363
cluster-size
cluster-size
20
80
55
1
1
NIL
HORIZONTAL

SLIDER
55
369
215
402
cxcr7-fraction
cxcr7-fraction
0
100
30
1
1
NIL
HORIZONTAL

SLIDER
940
450
1100
483
speed
speed
0
6
6
.1
1
NIL
HORIZONTAL

SLIDER
585
330
745
363
cxcr4-degradation
cxcr4-degradation
0
1
0.3
.05
1
NIL
HORIZONTAL

BUTTON
35
270
195
303
cut
cut-by-fraction
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
35
230
195
263
cut-fraction
cut-fraction
0
100
75
1
1
NIL
HORIZONTAL

SLIDER
405
410
565
443
scale
scale
0
40
20
1
1
NIL
HORIZONTAL

SLIDER
940
410
1100
443
movement-threshold
movement-threshold
0
1
0.85
.01
1
NIL
HORIZONTAL

PLOT
245
185
1095
305
Cxcl12a level
pxcor
[Cxcl12a]
0.0
100.0
0.0
40.0
false
false
"" ""
PENS
"default" 1.0 2 -16777216 true "" "clear-plot\nask patches with [pycor = 0] \n[plotxy pxcor Cxcl12a]"

CHOOSER
1715
465
1853
510
celltype_to_make
celltype_to_make
"cxcr4 cell" "cxcr7 cell" "neuromast"
0

BUTTON
1715
415
1815
448
NIL
make-links
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
235
450
395
483
Cxcl12a-diffusion-distance
Cxcl12a-diffusion-distance
0
20
3
1
1
NIL
HORIZONTAL

BUTTON
405
330
565
363
Cxcl12a heatshock activate
ask patches\n[set Cxcl12a Cxcl12a_HS_level]\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
405
370
565
403
Cxcl12a_HS_level
Cxcl12a_HS_level
0
30
10
5
1
NIL
HORIZONTAL

BUTTON
1710
140
1857
173
migration distance
file-open \"full_degruns_run2.txt\"\nset iteration 0\nset cxcr4-degradation 0.0\nset cxcr7-degradation 0\nrepeat 11\n[\n\nrepeat 11\n[\nfile-write \"/ cxcr7-degradation is\"\nfile-write cxcr7-degradation\nfile-write \"cxcr4-degradation is \"\nfile-write cxcr4-degradation\nfile-write \"/\"\n\nrepeat 10\n[\nset iteration iteration + 1\nSetup-pllp-Migration\nrepeat 2000 [\n  \ngo\n\n]\nfile-write leading-turtle\n]\nset cxcr7-degradation cxcr7-degradation + 0.1\n\n]\n\nset cxcr4-degradation cxcr4-degradation + 0.1\nset cxcr7-degradation 0\nfile-write \"*****************\"\nfile-write \"/\"\n]\nfile-close
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
940
370
1100
403
edge-cell-active
edge-cell-active
0
1
-1000

MONITOR
1745
265
1832
310
NIL
leading-turtle
17
1
11

MONITOR
1747
337
1812
382
NIL
iteration
17
1
11

MONITOR
1736
213
1833
258
NIL
trailing-turtle
17
1
11

BUTTON
1715
100
1838
133
migrationdist2
file-open \"cxcr4-0_cxcr7-80.txt\"\nset iteration 0\n\nrepeat 50\n[\nset iteration iteration + 1\nSetup-pllp-Migration\nrepeat 200 [go]\nfile-write leading-turtle\nrepeat 200 [go]\nfile-write leading-turtle\nrepeat 200 [go]\nfile-write leading-turtle\nrepeat 200 [go]\nfile-write leading-turtle\nrepeat 200 [go]\nfile-write leading-turtle\n\n]\n\n\n\n\n\nfile-close
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1715
175
1844
208
migration-track
file-open \"single_tracks_cxcr4-50_cxcr7-10.txt\"\n\nrepeat 10\n[\nSetup-pllp-Migration\nrepeat 1000 [\n  \ngo\nif time-count mod 10 = 0\n[\nfile-write leading-turtle\n;file-write trailing-turtle\n]\n]\nfile-write \"/\"\n]\n\nfile-close
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
940
330
1100
363
gradient-sensing
gradient-sensing
0
1
-1000

TEXTBOX
380
310
465
328
Cxcl12a controls\n
11
0.0
1

TEXTBOX
95
310
175
328
pLLP setup\n
11
0.0
1

TEXTBOX
955
310
1095
328
pLLP movement behavior\n
11
0.0
1

TEXTBOX
810
310
890
328
Link controls
11
0.0
1

TEXTBOX
75
210
150
228
Cut controls\n
11
0.0
1

TEXTBOX
605
310
740
328
Cxcl12a degredation
11
0.0
1

BUTTON
30
80
212
113
reset to default parameters
set stripe-width 1\nset Cxcl12a-diffusion-rate 0.10\nset Cxcl12a-diffusion-distance 3\nset Cxcl12a-production-rate 3.0\nset Cxcl12a-degradation-rate 0.05\nset Cxcl12a_HS_level 10\nset cxcr4-degradation 0.30\nset cxcr7-degradation 0.8\n\n\nset cluster-size 55\nset cxcr7-fraction 30\nset cut-fraction 75\n\n\nset movement-threshold 0.85\nset speed 3.0\n\nset spring-length 0.30\nset spring-repulsion 0.01\nset spring-constant 0.15\n\n\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
1605
50
1875
725
NIL
11
0.0
0

BUTTON
15
165
222
198
HS with gradient response
\nset gradient-sensing true\n\nask patches\n[set Cxcl12a Cxcl12a_HS_level]\n\n\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
15
120
225
153
HS with threshold response
set gradient-sensing false\n\nask patches\n[set Cxcl12a Cxcl12a_HS_level]\n\n\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
# An agent-based model of the migration of the zebrafish posterior lateral line primordium (pLLP)

##General Information

The model consists of three types of agents    
- Patches, of which a number (usually a symmetrical stipe along the middle of the model world) produce a diffusible signaling molecule, Cxcl12a    
- cxcr4-cells, which are able to respond to this Cxcl12a and are able to degrade it locally    
- cxcr7b-cells, which are able to respond to this Cxcl12a and are very effective at degrading Cxcl12a

cxcr4 cells and cxcr7-cells are connected by links which act as springs, with three user-definable visco-elasctic properties. 

##Parameters

The left-hand side of the interface screen contains slider which control the parameters of the model. One these parameters are set, the model is initialized by the "setup" and "go" buttons. "Setup" must be called before "Go" to correcly initialize the model run.

The parameters, in order, are as folllows:


###pLLP setup controls    
####cluster-size    
>Controls the size of the pLLP (roughly, the number of cells in the model pLLP. Specifically, this controls the length (along the x-axis) of an oval of turtles which will be produced when the model is initialized

####fraction    
>Controls the fraction (as a percent of total length) of the pLLP which will consist of cxcr7b-cells. The remaining fraction will default to cxcr4 expressing cells. These cells will always be produced such that cxcr7b-cells are in the trailing domain and cxcr4 cells are in the leading domain. Note that it is possible to have pLLP composed uniformly of cxcr4b-cells or cxcr7b-cells by setting the fraction to 0 or 100, respectively.


###Cxcl12a controls    
####stripe-width     
>Controls the width (in patches) of the central stripe of Cxcl12a-expressing cells. This stripe is always symmterical around the horizontal center of the model world

####Cxcl12a-diffusion-rate    
>Determines the "speed" of Cxcl12a diffusion (how much of the value of each patch's Cxcl12a is transported to neighboring patches during a diffusion iteration

####Cxcl12a-diffusion-distance    
>Determines the distance Cxcl12a will diffuse (specifically, the number of diffusion iterations the model completes per time point)

####Cxcl12a-prodiction-rate    
>The rate at which Cxcl12a is produced by patches within the production stripe (see stripe-width)

####Cxcl12a-degeredation-rate    
>The rate at which Cxcl12a is degraded by patches. Note that this is global rate for Cxcl12a degredation, and not related to the rate at which turtle agents (cxcr4b and cxcr7b cells) degrade Cxcl12a locally

####Cxcl12a_HS_level    
>determines the "strength" of the Cxcl12a induction during a modelled heatshock induction of a Cxcl12a transgene.

####Cxcl12a heatshock activation    
>This button controls the global induction of Cxcl12a in all patches. When activem this button causes every patch in the model world to express Cxcl12a at a rate determined by Cxcl12a_HS_level


###Cxcl12a-degradation    
####Cxcr4-degradation    
>Controls the rate at which cxcr4-cells degrade Cxcl12a locally (within the patch they currently reside on). Ranges from 0 (no degradation) to 100 (complete degradation)

####Cxcr7-degradation    
>Controls the rate at which cxcr7-cells degrade Cxcl12a locally (within the patch they currently reside on). Ranges from 0 (no degradation) to 100 (complete degradation)

####Cxcl12a-degradation   
>Controls the basal rate at which patches degrade Cxcl12a
     


###pLLP movement behaviour

####gradient sensing    
>This togge controls whether agents move by sensing a gradient of Cxcl12a between their current location and the location one patch in their current heading direction (gradient sensing ON) or whether agents respond to an above-threshold level of Cxcl12a one patch ahead of them in their current heading direction (gradient sensing OFF)

####tip-cell    
>This toggle determines whether all cxcr4b-cells can respond to cxcr4b (tip cell OFF) or whether movement by cxcr4b is resticted only to cells at a free edge of the pLLP (tip-cell ON)

####movement-probability    
>Determines the threshold of Cxcl12a in the patch ahead at which a turtle will move forward. This threshold is scaled form 0 to 1 accoring to the following hill function:    
>
>_[Cxcl12a-ahead] / 1 + [Cxcl12a-ahead]_.     
>
>Note that this slider is also used if the agents are behaving under the gradient-sensing behaviour. This slider may need to be adjusted for this conditions 

####speed    
>determines the distance (in patches) that a turtle will move forward in a given movement iteration. Note that this can be a fraction of a patch.

###Link Control

####spring-constant
>Controls the spring constant of links joining neighboring turtles (defined as "the measure of the "tautness" of the spring. It is the "resistance" to change in their length. spring-constant is the force the spring would exert if it's length were changed by 1 unit.")

####spring-length
>Controls the spring length of links joining neighboring turtles (defined as "the "zero-force" length or the natural length of the springs. This is the length which all springs try to achieve either by pushing out their nodes or pulling them in."

####spring-repulsion
>Controls the spring repulsion of links joining neighboring turtles  (defined as "a measure of repulsion between the nodes. It is the force that 2 nodes at a distance of 1 unit will exert on each other."

###cut controls    
####cut-fraction     
>Controls the position at which link between agents will be severed to simulate a laser ablation. This is measures as a function of the position along the pLLP at the current timestep, and so is not the same as cxcr7b-fraction, above. For example, a value of 70 here will cut at a point 70% of the distance from the back of the pLLP to the front.

####cut     
>This command severs the links between agents in the pLLP at a point determined by cut-fraction

###Other controls

####Setup    
>Initialized the program and agents. This should be called before running the model.

####Go
>Runs the model. This will run the model until clicked again to stop

####Reset to default parameters
>This will reset the program to the default parameters

####threshold model heatshock
>This will simulate a heatshock using "threshold" Cxcl12a assumptions. This is equivalent to the experiment in Fig. 2B. Note that this is functionally similar to setting the "gradient-sensing" switch to "OFF" and initializing a heat shock. "Go" must be active for this button to function. 
   

####gradient model heatshock
>This will simulate a heatshock using "gradient" Cxcl12a assumptions. This is equivalent to the experiment in Fig. 2C. Note that this is functionally similar to setting the "gradient-sensing" switch to "ON" and initializing a heat shock. "Go" must be active for this button to function.


## CREDITS AND REFERENCES

Damian Dalle Nogare, Swetha Rao and Ajay Chitnis.    
Section on Neural Developmental Dynamcis    
Eunice Kennedy Shriver National Institue of Child Health and Development    
National Institutes of Health
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

campsite
false
0
Polygon -7500403 true true 150 11 30 221 270 221
Polygon -16777216 true false 151 90 92 221 212 221
Line -7500403 true 150 30 150 225

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

clock2
true
0
Circle -7500403 true true 30 30 240
Polygon -16777216 true false 150 46 45 135 120 135 120 255 180 255 180 135 255 135
Circle -16777216 true false 120 120 60

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cxcr4
true
1
Polygon -7500403 false false 150 15 90 60 60 30 45 90 15 75 30 150 0 135 15 195 30 240 90 285 150 300 225 285 285 225 300 165 300 105 270 150 285 75 240 105 240 30 210 60 150 15
Rectangle -2674135 true true 75 90 135 165
Polygon -2674135 true true 225 45 150 0 60 30 60 90 15 75 30 150 0 135 30 240 90 285 150 300 225 285 285 225 300 165 300 105 270 150 285 75 240 105 240 30 225 45

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

growth_cone
true
0
Polygon -7500403 true true 130 300 124 206 110 207 94 201 81 183 75 171 74 95 79 79 88 74 97 79 100 95 101 151 104 169 115 180 126 169 129 31 132 19 145 16 153 20 158 32 162 142 166 149 177 149 185 137 185 119 189 108 199 103 212 108 215 121 215 144 210 165 196 177 176 181 164 182 159 302
Rectangle -7500403 true true 150 90 150 150

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

leaf 2
false
0
Rectangle -7500403 true true 144 218 156 298
Polygon -7500403 true true 150 263 133 276 102 276 58 242 35 176 33 139 43 114 54 123 62 87 75 53 94 30 104 39 120 9 155 31 180 68 191 56 216 85 235 125 240 173 250 165 248 205 225 247 200 271 176 275

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
